* GENERAL NOTES FOR NDNS19-64
* Didn't record the data cleaning process, so this may need to be redone ASP...
* All variables created are coded with a letter (a, b etc) and also 'l' or 'h', to show whether low or high

/* 	NDNSyp: diary data for YP in NDNSYP is incomprehensible (but it does exist!).  Based on NDNS19-64, the variable purportedly in grams must be 
	divided by 1428.57 (about 10k/7) to get an actual figure in grams (although this is contradicted by the userguide, which says it used the 
	data that it clearly didn't; see p844).  Furthermore, the daily data (from day.dta) appears to have been multiplied by 7 (i.e. turned into 
	weekly averages) compared to the daily data (var adnuts10).  Hence have not used NDNSyp much here...		*/



**************************************************
* uni_ah - DAILY LIMITS: 4 units for men, 3 for women 
**************************************************
quietly {
	capture drop uni_ah*
	local i = 1
	while `i'<=7	{
				gen double uni_ah`i'= alcuni`i'
				replace uni_ah`i' = 4 if (alcuni`i'>4 & respsex==1)
				replace uni_ah`i' = 3 if (alcuni`i'>3 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_ahtot=0
	capture replace uni_ahtot=0
	while `i'<=7	{
				replace uni_ahtot = uni_ahtot + uni_ah`i'
				local i = `i'+1
				}
	recode uni_ahtot (nonmiss=.) if alcundr==.
	label var uni_ahtot "DAILY LIMITS: 4(m) 3(f)"
	}
sum alcundr uni_ahtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


**************************************************
* uni_al - DAILY LIMITS: 3 units for men, 2 for women 
**************************************************
quietly {
	capture drop uni_al*
	local i = 1
	while `i'<=7	{
				gen double uni_al`i'= alcuni`i'
				replace uni_al`i' = 3 if (alcuni`i'>3 & respsex==1)
				replace uni_al`i' = 2 if (alcuni`i'>2 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_altot=0
	capture replace uni_altot=0
	while `i'<=7	{
				replace uni_altot = uni_altot + uni_al`i'
				local i = `i'+1
				}
	recode uni_altot (nonmiss=.) if alcundr==.
	label var uni_altot "DAILY LIMITS: 3(m) 2(f)"
	}


*****************************************************
* uni_ch - WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop uni_ch*
	gen double uni_ch1 = alcundr
	replace uni_ch1 = 21 if (alcundr>21 & respsex==1)
	replace uni_ch1 = 14 if (alcundr>14 & respsex==2)
	recode uni_ch1 (nonmiss=.) if alcundr==.
	label var uni_ch1 "WEEKLY LIMITS diary: 21(m) 14(f)"


	gen double uni_ch2 = dratndns
	replace uni_ch2 = 21 if (dratndns>21 & respsex==1)
	replace uni_ch2 = 14 if (dratndns>14 & respsex==2)
	recode uni_ch2 (nonmiss=.) if dratndns==.
	label var uni_ch2 "WEEKLY LIMITS interview: 21(m) 14(f)"
	}


*****************************************************
* uni_cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop uni_cl*
	gen double uni_cl1 = alcundr
	replace uni_cl1 = 21 if (alcundr>28 & respsex==1)
	replace uni_cl1 = 14 if (alcundr>21 & respsex==2)
	recode uni_cl1 (nonmiss=.) if alcundr==.
	label var uni_cl1 "WEEKLY LIMITS diary: 28(m) 21(f)"


	gen double uni_cl2 = dratndns
	replace uni_cl2 = 21 if (dratndns>28 & respsex==1)
	replace uni_cl2 = 14 if (dratndns>21 & respsex==2)
	recode uni_cl2 (nonmiss=.) if dratndns==.
	label var uni_cl2 "WEEKLY LIMITS interview: 28(m) 21(f)"
	}



*******************************************************
* uni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************
* quietly {
	capture drop uni_d*
	gen double uni_dtot = alcundr
	replace uni_dtot = 0   if (alcundr>0    & respsex==1 & respage>=19 & respage<=24)
	replace uni_dtot = 0.1 if (alcundr>0.1  & respsex==1 & respage>=25 & respage<=34)
	replace uni_dtot = 1.8 if (alcundr>1.8  & respsex==1 & respage>=35 & respage<=44)
	replace uni_dtot = 5.1 if (alcundr>5.1  & respsex==1 & respage>=45 & respage<=54)
	replace uni_dtot = 7.2 if (alcundr>7.2  & respsex==1 & respage>=55 & respage<=64)
	replace uni_dtot = 0   if (alcundr>0    & respsex==2 & respage>=19 & respage<=34)
	replace uni_dtot = 0.2 if (alcundr>0.2  & respsex==2 & respage>=35 & respage<=44)
	replace uni_dtot = 0.5 if (alcundr>0.5  & respsex==2 & respage>=45 & respage<=54)
	replace uni_dtot = 1.6 if (alcundr>1.6  & respsex==2 & respage>=55 & respage<=64)
	recode uni_dtot (*=.) if alcundr==.
	label var uni_dtot "AGE DISAGGREGATED NADIR - White 2002"
*	}
sum alcundr uni_dtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight



*******************************************************
* uni_bm - BINGE-DRINKING: 5 units per day for men and women
*******************************************************
quietly {
	capture drop uni_bm*
	local i = 1
	while `i'<=7	{
				gen double uni_bm`i'= alcuni`i'
				replace uni_bm`i' = 5 if (alcuni`i'>5)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_bmtot=0
	capture replace uni_bmtot=0
	while `i'<=7	{
				replace uni_bmtot = uni_bmtot + uni_bm`i'
				local i = `i'+1
				}
	recode uni_bmtot (nonmiss=.) if alcundr==.
	label var uni_bmtot "DAILY BINGE: 5(m&f)"
	}
sum alcundr uni_bmtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*******************************************************
* uni_bh - BINGE-DRINKING: 8 units per day for men, 6 for women
*******************************************************
quietly {
	capture drop uni_bh*
	local i = 1
	while `i'<=7	{
				gen double uni_bh`i'= alcuni`i'
				replace uni_bh`i' = 8 if (alcuni`i'>8 & respsex==1)
				replace uni_bh`i' = 6 if (alcuni`i'>6 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_bhtot=0
	capture replace uni_bhtot=0
	while `i'<=7	{
				replace uni_bhtot = uni_bhtot + uni_bh`i'
				local i = `i'+1
				}
	recode uni_bhtot (nonmiss=.) if alcundr==.
	label var uni_bhtot "DAILY BINGE: 8(m) 6(f)"
	}
sum alcundr uni_bhtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*******************************************************
* uni_bl - BINGE-DRINKING: 6 units per day for men, 4 for women
*******************************************************
quietly {
	capture drop uni_bl*
	local i = 1
	while `i'<=7	{
				gen double uni_bl`i'= alcuni`i'
				replace uni_bl`i' = 6 if (alcuni`i'>6 & respsex==1)
				replace uni_bl`i' = 4 if (alcuni`i'>4 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni_bltot=0
	capture replace uni_bltot=0
	while `i'<=7	{
				replace uni_bltot = uni_bltot + uni_bl`i'
				local i = `i'+1
				}
	recode uni_bltot (nonmiss=.) if alcundr==.
	label var uni_bltot "DAILY BINGE: 6(m) 4(f)"
	}
sum alcundr uni_bltot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight

*******************************************************
* uni_em - BINGE&WEEK: 5(day) and 28/21(wk)
*******************************************************
quietly {
	capture drop uni_em*
	
	gen double uni_em1=uni_bmtot
	replace uni_em1 = 28 if (uni_em1>28 & respsex==1)
	replace uni_em1 = 21 if (uni_em1>21 & respsex==2)
	recode uni_em1 (nonmiss=.) if alcundr==.
	label var uni_em1 "BINGE&WEEK: 5(day) & 28/21(wk)"
	}


*******************************************************
* uni_eh - BINGE&WEEK: 8/6(day) and 28/21(wk)
*******************************************************
quietly {
	capture drop uni_eh*

	gen double uni_eh1=uni_bhtot
	replace uni_eh1 = 28 if (uni_eh1>28 & respsex==1)
	replace uni_eh1 = 21 if (uni_eh1>21 & respsex==2)
	recode uni_eh1 (nonmiss=.) if alcundr==.
	label var uni_eh1 "BINGE&WEEK: 8/6(day) & 28/21(wk)"
	}

*******************************************************
* uni_el - BINGE&WEEK: 6/4(day) and 28/21(wk)
*******************************************************
quietly {
	capture drop uni_el*
	
	gen double uni_el1=uni_bmtot
	replace uni_el1 = 28 if (uni_el1>28 & respsex==1)
	replace uni_el1 = 21 if (uni_el1>21 & respsex==2)
	recode uni_el1 (nonmiss=.) if alcundr==.
	label var uni_el1 "BINGE&WEEK: 6/4(day) & 28/21(wk)"
	}




******************************************************************************************************************************************************
******************************************************************************************************************************************************
*** REDUCED TO ZERO RATHER THAN THE LIMIT  ***********************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************



**************************************************
* uni0ah - Reduced to DAILY LIMITS: 4 units for men, 3 for women 
**************************************************
quietly {
	capture drop uni0ah*
	local i = 1
	while `i'<=7	{
				gen double uni0ah`i'= alcuni`i'
				replace uni0ah`i' = 0 if (alcuni`i'>4 & respsex==1)
				replace uni0ah`i' = 0 if (alcuni`i'>3 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni0ahtot=0
	capture replace uni0ahtot=0
	while `i'<=7	{
				replace uni0ahtot = uni0ahtot + uni0ah`i'
				local i = `i'+1
				}
	recode uni0ahtot (nonmiss=.) if alcundr==.
	label var uni0ahtot "Reduced to DAILY LIMITS: 4(m) 3(f)"
	}


**************************************************
* uni0al - Reduced to DAILY LIMITS: 3 units for men, 2 for women 
**************************************************
quietly {
	capture drop uni0al*
	local i = 1
	while `i'<=7	{
				gen double uni0al`i'= alcuni`i'
				replace uni0al`i' = 0 if (alcuni`i'>3 & respsex==1)
				replace uni0al`i' = 0 if (alcuni`i'>2 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni0altot=0
	capture replace uni0altot=0
	while `i'<=7	{
				replace uni0altot = uni0altot + uni0al`i'
				local i = `i'+1
				}
	recode uni0altot (nonmiss=.) if alcundr==.
	label var uni0altot "Reduced to DAILY LIMITS: 3(m) 2(f)"
	}

*****************************************************
* uni0ch - Reduced to WEEKLY LIMITS: 21 units for men, 14 for women 
*****************************************************
quietly {
	capture drop uni0ch*
	gen double uni0ch1 = alcundr
	replace uni0ch1 = 0 if (alcundr>21 & respsex==1)
	replace uni0ch1 = 0 if (alcundr>14 & respsex==2)
	recode uni0ch1 (nonmiss=.) if alcundr==.
	label var uni0ch1 "Reduced WEEKLY LIMITS diary: 21(m) 14(f)"


	gen double uni0ch2 = dratndns
	replace uni0ch2 = 0 if (dratndns>21 & respsex==1)
	replace uni0ch2 = 0 if (dratndns>14 & respsex==2)
	recode uni0ch2 (nonmiss=.) if dratndns==.
	label var uni0ch2 "Reduced to WEEKLY LIMITS interview: 21(m) 14(f)"
	}


*****************************************************
* uni0cl - WEEKLY LIMITS: 28 units for men, 21 for women 
*****************************************************
quietly {
	capture drop uni0cl*
	gen double uni0cl1 = alcundr
	replace uni0cl1 = 0 if (alcundr>28 & respsex==1)
	replace uni0cl1 = 0 if (alcundr>21 & respsex==2)
	recode uni0cl1 (nonmiss=.) if alcundr==.
	label var uni0cl1 "Reduced to WEEKLY LIMITS diary: 28(m) 21(f)"


	gen double uni0cl2 = dratndns
	replace uni0cl2 = 0 if (dratndns>28 & respsex==1)
	replace uni0cl2 = 0 if (dratndns>21 & respsex==2)
	recode uni0cl2 (nonmiss=.) if dratndns==.
	label var uni0cl2 "Reduced to WEEKLY LIMITS interview: 28(m) 21(f)"
	}


*******************************************************
* uni_d - AGE-DISAGRREGATED NADIR: as per White
*******************************************************


/*	THIS SECTION IS IGNORED

* quietly {
	capture drop uni_d*
	gen double uni_dtot = alcundr
	replace uni_dtot = 0   if (alcundr>0    & respsex==1 & respage>=19 & respage<=24)
	replace uni_dtot = 0.1 if (alcundr>0.1  & respsex==1 & respage>=25 & respage<=34)
	replace uni_dtot = 1.8 if (alcundr>1.8  & respsex==1 & respage>=35 & respage<=44)
	replace uni_dtot = 5.1 if (alcundr>5.1  & respsex==1 & respage>=45 & respage<=54)
	replace uni_dtot = 7.2 if (alcundr>7.2  & respsex==1 & respage>=55 & respage<=64)
	replace uni_dtot = 0   if (alcundr>0    & respsex==2 & respage>=19 & respage<=34)
	replace uni_dtot = 0.2 if (alcundr>0.2  & respsex==2 & respage>=35 & respage<=44)
	replace uni_dtot = 0.5 if (alcundr>0.5  & respsex==2 & respage>=45 & respage<=54)
	replace uni_dtot = 1.6 if (alcundr>1.6  & respsex==2 & respage>=55 & respage<=64)
	recode uni_dtot (*=.) if alcundr==.
	label var uni_dtot "AGE DISAGGREGATED NADIR - White 2002"
*	}
sum alcundr uni_dtot // [fweight=diarywgt] doesn't work - can't use pweights, need to create a fweight


*/

*******************************************************
* uni0bm - BINGE-DRINKING: 5 units per day for men and women
*******************************************************
quietly {
	capture drop uni0bm*
	local i = 1
	while `i'<=7	{
				gen double uni0bm`i'= alcuni`i'
				replace uni0bm`i' = 0 if (alcuni`i'>5)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni0bmtot=0
	capture replace uni0bmtot=0
	while `i'<=7	{
				replace uni0bmtot = uni0bmtot + uni0bm`i'
				local i = `i'+1
				}
	recode uni0bmtot (nonmiss=.) if alcundr==.
	label var uni0bmtot "Reduced to DAILY BINGE: 5(m&f)"
	}


*******************************************************
* uni0bh - Reduced to BINGE-DRINKING: 8 units per day for men, 6 for women
*******************************************************
quietly {
	capture drop uni0bh*
	local i = 1
	while `i'<=7	{
				gen double uni0bh`i'= alcuni`i'
				replace uni0bh`i' = 0 if (alcuni`i'>8 & respsex==1)
				replace uni0bh`i' = 0 if (alcuni`i'>6 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni0bhtot=0
	capture replace uni0bhtot=0
	while `i'<=7	{
				replace uni0bhtot = uni0bhtot + uni0bh`i'
				local i = `i'+1
				}
	recode uni0bhtot (nonmiss=.) if alcundr==.
	label var uni0bhtot "Reduced to DAILY BINGE: 8(m) 6(f)"
	}

*******************************************************
* uni0bl - Reduced to BINGE-DRINKING: 6 units per day for men, 4 for women
*******************************************************
quietly {
	capture drop uni0bl*
	local i = 1
	while `i'<=7	{
				gen double uni0bl`i'= alcuni`i'
				replace uni0bl`i' = 0 if (alcuni`i'>6 & respsex==1)
				replace uni0bl`i' = 0 if (alcuni`i'>4 & respsex==2)
				local i =`i'+1
				}
	local i = 1
	capture gen double uni0bltot=0
	capture replace uni0bltot=0
	while `i'<=7	{
				replace uni0bltot = uni0bltot + uni0bl`i'
				local i = `i'+1
				}
	recode uni0bltot (nonmiss=.) if alcundr==.
	label var uni0bltot "Reduced to DAILY BINGE: 6(m) 4(f)"
	}


/* SECTION IGNORED

*******************************************************
* uni_em - BINGE&WEEK: 5(day) and 28/21(wk)
*******************************************************
quietly {
	capture drop uni_em*
	
	gen double uni_em1=uni_bmtot
	replace uni_em1 = 28 if (uni_em1>28 & respsex==1)
	replace uni_em1 = 21 if (uni_em1>21 & respsex==2)
	recode uni_em1 (nonmiss=.) if alcundr==.
	label var uni_em1 "BINGE&WEEK: 5(day) & 28/21(wk)"
	}


*******************************************************
* uni_eh - BINGE&WEEK: 8/6(day) and 28/21(wk)
*******************************************************
quietly {
	capture drop uni_eh*

	gen double uni_eh1=uni_bhtot
	replace uni_eh1 = 28 if (uni_eh1>28 & respsex==1)
	replace uni_eh1 = 21 if (uni_eh1>21 & respsex==2)
	recode uni_eh1 (nonmiss=.) if alcundr==.
	label var uni_eh1 "BINGE&WEEK: 8/6(day) & 28/21(wk)"
	}

*******************************************************
* uni_el - BINGE&WEEK: 6/4(day) and 28/21(wk)
*******************************************************
quietly {
	capture drop uni_el*
	
	gen double uni_el1=uni_bmtot
	replace uni_el1 = 28 if (uni_el1>28 & respsex==1)
	replace uni_el1 = 21 if (uni_el1>21 & respsex==2)
	recode uni_el1 (nonmiss=.) if alcundr==.
	label var uni_el1 "BINGE&WEEK: 6/4(day) & 28/21(wk)"
	}

*/

******************************************************************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************



*******************************************************
* FINAL OUTPUT
*******************************************************

* These are all working files that are not needed to present the results
capture drop uni_ah1-uni_ah7
capture drop uni_al1-uni_al7
capture drop uni_bm1-uni_bm7
capture drop uni_bh1-uni_bh7
capture drop uni_bl1-uni_bl7

capture drop uni0ah1-uni0ah7
capture drop uni0al1-uni0al7
capture drop uni0bm1-uni0bm7
capture drop uni0bh1-uni0bh7
capture drop uni0bl1-uni0bl7
